<?php
// banip.php - Web Service for IP Management
header('Content-Type: text/plain');

$secret_key = 'ACTIVISION_SECRET_KEY_12345'; // Change this to a secure key

// Authenticate request
if (!isset($_GET['key']) || $_GET['key'] !== $secret_key) {
    header('HTTP/1.1 403 Forbidden');
    die('Access denied. Invalid security key.');
}

if (!isset($_GET['action']) || !isset($_GET['ip'])) {
    die('Missing parameters. Usage: banip.php?action=[ban|unban]&ip=[IP_ADDRESS]&key=[SECRET_KEY]');
}

$action = $_GET['action'];
$ip = $_GET['ip'];

// Validate IP address
if (!filter_var($ip, FILTER_VALIDATE_IP)) {
    die('Invalid IP address format.');
}

$file = 'banned_ips.txt';

// Create file if it doesn't exist
if (!file_exists($file)) {
    file_put_contents($file, '');
}

if ($action === 'ban') {
    // Add IP to banned list
    $current = file_get_contents($file);
    if (strpos($current, $ip) === false) {
        file_put_contents($file, $ip . PHP_EOL, FILE_APPEND);
        echo "IP $ip banned successfully.";
    } else {
        echo "IP $ip is already banned.";
    }
} elseif ($action === 'unban') {
    // Remove IP from banned list
    $banned_ips = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $key = array_search($ip, $banned_ips);
    if ($key !== false) {
        unset($banned_ips[$key]);
        file_put_contents($file, implode(PHP_EOL, $banned_ips) . PHP_EOL);
        echo "IP $ip unbanned successfully.";
    } else {
        echo "IP $ip was not found in banned list.";
    }
} else {
    echo "Invalid action. Use 'ban' or 'unban'.";
}
?>